-- change directory to program location
parse source  . . pgm
call directory filespec('L', pgm) 

-- create a new document and add a blank page
doc=.bsf~new("org.apache.pdfbox.pdmodel.PDDocument")
page=.bsf~new("org.apache.pdfbox.pdmodel.PDPage")
doc~addPage(page)

-- load the font file
fontfile=.bsf~new("java.io.File", "resources\arial.ttf")
fontclass = "org.apache.pdfbox.pdmodel.font.PDType0Font"
font=BSF.loadClass(fontclass)~load(doc,fontfile)

-- set the xmp metadata
xmp=BSF.loadClass("org.apache.xmpbox.XMPMetadata")~createXMPMetadata
dc=xmp~createAndAddDublinCoreSchema
dc~setTitle("15-PDFa.pdf");
id=xmp~createAndAddPDFAIdentificationSchema
id~setPart(1);
id~setConformance("B");
serializer=.bsf~new("org.apache.xmpbox.xml.XmpSerializer")
baos=.bsf~new("java.io.ByteArrayOutputStream")
serializer~serialize(xmp, baos,"true")
metadata=.bsf~new("org.apache.pdfbox.pdmodel.common.PDMetadata",doc)
metadata~importXMPMetadata(baos~toByteArray)
doc~getDocumentCatalog~setMetadata(metadata)

-- define the color profile
colorprofile=.bsf~new("java.io.FileInputStream", "resources\sRGB.icc")
intentclass = "org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent"
intent=.bsf~new(intentclass,doc,colorprofile)
intent~setInfo("sRGB IEC61966-2.1")
intent~setOutputCondition("sRGB IEC61966-2.1")
intent~setOutputConditionIdentifier("sRGB IEC61966-2.1")
intent~setRegistryName("http://www.color.org")
doc~getDocumentCatalog~addOutputIntent(intent)

-- create a content stream
cont=.bsf~new("org.apache.pdfbox.pdmodel.PDPageContentStream",doc,page)

-- use the content stream to insert content
cont~beginText
cont~setFont(font, 22)
cont~setLeading(25f)
cont~newLineAtOffset( 100, 700 )
cont~showText("This is a PDF/A Document")
cont~endText
cont~close
nocclass="org.apache.pdfbox.pdfwriter.compress.CompressParameters"
noc=BSF.loadClass(nocclass)

-- save and close the document file
doc~save("15-PDFa.pdf",noc~NO_COMPRESSION)
doc~close


-- get java support
::requires "BSF.CLS"